﻿function JProjection(owner, parent, name, width, height, left, top, zoomEnabled, zoom, tZoomEnabled, tZoom, rect, tab)
{
	var self = this,
		_disposed = false,
		_dummy = 0,
		_afm,
		_img,
		_position = null,
		_zoomEnabled = utils.parseBool(zoomEnabled);
		_timeZoomEnabled = utils.parseBool(tZoomEnabled);

	this.initialize (owner, parent, name, null, null, rect, null, null, null, tab);

	this.methods = (cmRender | cmLoad);
	this.maxWidth = parseInt(width);
	this.maxHeight = parseInt(height);
	this.posLeft = parseInt(left);
	this.posTop = parseInt(top);
	this.zoom = parseInt(zoom);
	this.tZoom = parseInt(tZoom);

	this.render  = render;
	this.load    = load;
	this.dispose = dispose;

	this.owner.addImage("projNav", "ProjArrow.png", "controls");
	this.owner.addImage("projNavTime", "projArrowTime.png", "controls");

	_afm = self.getForm().name; 

	if (_timeZoomEnabled)
		_img = self.owner.images['projNavTime'];
	else
		_img = self.owner.images['projNav'];

	function render(fs)
	{
		fs.append('<div class="imageBox" id="' + self.name + '_box" style="' + self.rect + '; overflow:hidden">');
		fs.append('<img class="image" id="' + self.name + '" src="" style="display:none" />');
		fs.append('</div>');
		fs.append('<div id="' + self.name + '_nav" class="projectionNavigation" >');
		fs.append('<div id="' + self.name + '_loadMsg" style="padding-bottom: 3;">Loading...</div>');

		if ((browser.isIE) && (browser.version < 7))
		{
			var w = _img.width;
			var h = _img.height;
			if (w < 100)	// fix for IE, image is not always displayed
			{
				w = 133;
				h = 108;
			}
			fs.append('<span id="' + self.name + '_navArrow" style="width:' + w + '; height:' + h + ';filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src=\'' + _img.src + '\', sizingMethod=\'scale\');"></span>');
			fs.append('<img src="images/transparent.gif" usemap="#' + self.name + '_navMap" border="0" style="position:relative; left:-' + w + '; width:' + w + '; height:' + h + '">');
		}
		else
			fs.append('<img id="' + self.name + '_navArrow" src="' + _img.src + '" usemap="#' + self.name + '_navMap" border="0">');

		fs.append('<map name="' + self.name + '_navMap" id="' + self.name + '_navMap">');
		fs.append('<area id="' + self.name + '_up" title="Posun nahoru" shape="poly" coords="56,0,70,15,68,24,43,24,40,15" />');
		fs.append('<area id="' + self.name + '_right" title="Posun doprava" shape="poly" coords="108,52,94,68,84,64,85,41,93,38" />');
		fs.append('<area id="' + self.name + '_down" title="Posun dolů" shape="poly" coords="56,106,70,92,66,82,44,82,41,90" />');
		fs.append('<area id="' + self.name + '_left" title="Posun doleva" shape="poly" coords="3,53,18,67,26,66,26,41,17,39" />');
		fs.append('<area id="' + self.name + '_upL" title="Posun vlevo nahoru" shape="poly" coords="17,14,39,14,41,23,25,39,17,37" />');
		fs.append('<area id="' + self.name + '_upR" title="Posun vpravo nahoru" shape="poly" coords="94,14,94,34,84,38,69,23,71,14" />');
		fs.append('<area id="' + self.name + '_downR" title="Posun vpravo dolů" shape="poly" coords="93,91,93,68,84,66,68,84,71,90" />');
		fs.append('<area id="' + self.name + '_downL" title="Posun vlevo dolů" shape="poly" coords="17,90,39,90,43,81,26,66,17,69" />');
		fs.append('<area id="' + self.name + '_zoom" title="Zvětšit" shape="poly" coords="41,24,68,24,83,39,83,52,27,52,27,38" />');
		fs.append('<area id="' + self.name + '_unzoom" title="Zmenšit" shape="poly" coords="69,80,43,80,27,65,27,52,84,52,84,66" />');

		if (_timeZoomEnabled)
		{
			fs.append('<area id="' + self.name + '_tZoom" title="Zvětšit časovou osu" shape="poly" coords="113,53,118,53,128,44,128,14,103,14,103,44">');
			fs.append('<area id="' + self.name + '_tUnzoom" title="Zmenšit časovou osu" shape="poly" coords="113,54,118,54,128,64,128,94,103,94,103,64">');
		}
		fs.append('</map>');
		fs.append('</div>');
	}

	function load()
	{
		_position = self.checkPosition();

		var style = self.$$('_box').style;
		if (_position.isRightMost)
		{
			var pw = self.$$('_box').parentNode.clientWidth;
			if (pw == 0)
				pw = self.$(self.parent).clientWidth;

			self.rect.width = pw - self.rect.left - 8; 
			style.width = self.rect.width;
		}

		if (_position.isBottomMost)
		{
			var ph = self.$$('_box').parentNode.clientHeight;
			if (ph == 0)
				ph = self.$(self.parent).clientHeight;

			self.rect.height = ph - self.rect.top - self.$$('_nav').offsetHeight - 12; 
			style.height = self.rect.height;
		}

		style = self.$$('_nav').style;
		style.top = self.rect.top + self.$$('_box').offsetHeight + 10;
		style.width = self.rect.width;

		setSrc(0, 0);
		self.$$('_navMap').onclick = navClick;
	}

	function setSrc(hShift, vShift, _zoom, _tZoom)
	{
		_dummy++;

		var src = self.owner.cgiPath();
		if (self.owner.isPortalVersion())
			src += '&';
		else
			src += '?';


		src += 'act=getProjection&cid=' + self.owner.session + '&afm=' + _afm +
			 '&obj=' + self.name + '&width=' + self.rect.width + '&height=' + self.rect.height + '&dummy=' + _dummy;

		if ((hShift != null) && (hShift != 0))
		{
			self.posLeft += hShift;
			if (self.posLeft > self.maxWidth)
				self.posLeft = self.maxWidth;

			src += '&hShift=' + hShift;
		}

		if ((vShift != null) && (vShift != 0))
		{
			self.posTop += vShift;
			if (self.posTop > self.maxHeight)
				self.posTop = self.maxHeight;

			src += '&vShift=' + vShift;
		}

		if ((_zoom != null) && (_zoom != 0))
		{
			if (self.zoom != -999)
			{
				self.zoom += _zoom;
				if (self.zoom < -9)	self.zoom = -9;
				if (self.zoom > 40)	self.zoom = 40;
			}

			src += '&zoom=' + _zoom;
		}

		if ((_tZoom != null) && (_tZoom != 0))
		{
			if (self.tZoom != -999)
			{
				self.tZoom += _tZoom;
				if (self.tZoom < 0)	 self.tZoom = 0;
				if (self.tZoom > 15) self.tZoom = 15;

				src += '&tZoom=' + self.tZoom;
			}
			else
			{
				src += '&tZoom=' + _tZoom;
			}
		}

		self.$$('_loadMsg').style.visibility = 'inherit';
		self.$$().src = src;
		self.$$().onload = function()
			{
				this.style.display = 'inline';
				this.onload = null;
				self.$$('_loadMsg').style.visibility = 'hidden';
			}
	}

	function navClick(event)
	{
		var elem = utils.getEventElement(event),
			ctrl = utils.getCtrlKey(event);

		switch (elem.id)
		{
			case self.name + '_up':
				moveUp(ctrl);
				break;
			case self.name + '_upL':
				moveUpLeft(ctrl);
				break;
			case self.name + '_upR':
				moveUpRight(ctrl);
				break;
			case self.name + '_down':
				moveDown(ctrl);
				break;
			case self.name + '_downL':
				moveDownLeft(ctrl);
				break;
			case self.name + '_downR':
				moveDownRight(ctrl);
				break;
			case self.name + '_left':
				moveLeft(ctrl);
				break;
			case self.name + '_right':
				moveRight(ctrl);
				break;
			case self.name + '_zoom':
				doZoom();
				break;
			case self.name + '_unzoom':
				doZoom(true);
				break;
			case self.name + '_tZoom':
				zoomTime();
				break;
			case self.name + '_tUnzoom':
				zoomTime(true);
				break;
		}
	}

	var _marginConst = 10; 

	function moveUp(toMargin)
	{
		if (toMargin)
			setSrc(0, -_marginConst);
		else
		{
			if (self.zoom == -999)
				setSrc(0, -1);
			else
				setSrc(0, -parseInt(self.$$().clientHeight / 5));
		}
	}

	function moveUpLeft(toMargin)
	{
		if (toMargin)
			setSrc(-_marginConst, -_marginConst);
		else
		{
			if (self.zoom == -999)
				setSrc(-1, -1);
			else
				setSrc(-parseInt(self.$$().clientWidth / 5), -parseInt(self.$$().clientHeight / 5));
		}
	}

	function moveUpRight(toMargin)
	{
		if (toMargin)
			setSrc(_marginConst, -_marginConst);
		else
		{
			if (self.zoom == -999)
				setSrc(1, -1);
			else
				setSrc(parseInt(self.$$().clientWidth / 5), -parseInt(self.$$().clientHeight / 5));
		}
	}

	function moveDown(toMargin)
	{
		if (toMargin)
			setSrc(0, _marginConst);
		else
		{
			if (self.zoom == -999)
				setSrc(0, 1);
			else
				setSrc(0, parseInt(self.$$().clientHeight / 5));
		}
	}

	function moveDownLeft(toMargin)
	{
		if (toMargin)
			setSrc(-_marginConst, _marginConst);
		else
		{
			if (self.zoom == -999)
				setSrc(-1, 1);
			else
				setSrc(-parseInt(self.$$().clientWidth / 5), parseInt(self.$$().clientHeight / 5));
		}
	}

	function moveDownRight(toMargin)
	{
		if (toMargin)
			setSrc(_marginConst, _marginConst);
		else
		{
			if (self.zoom == -999)
				setSrc(1, 1);
			else
				setSrc(parseInt(self.$$().clientWidth / 5), parseInt(self.$$().clientHeight / 5));
		}
	}

	function moveLeft(toMargin)
	{
		if (toMargin)
			setSrc(-_marginConst, 0);
		else
		{
			if (self.zoom == -999)
				setSrc(-1, 0);
			else
				setSrc(-parseInt(self.$$().clientWidth / 5), 0);
		}
	}

	function moveRight(toMargin)
	{
		if (toMargin)
			setSrc(_marginConst, 0);
		else
		{
			if (self.zoom == -999)
				setSrc(1, 0);
			else
				setSrc(parseInt(self.$$().clientWidth / 5), 0);
		}
	}

	function doZoom(down)
	{
		if (down)
			setSrc(0, 0, -1);
		else
			setSrc(0, 0, 1);
	}

	function zoomTime(down)
	{
		if (down)
			setSrc(0, 0, 0, -1);
		else
			setSrc(0, 0, 0, 1);
	}

	function dispose()
	{
		self.$$('_navMap').onclick = null;

	}
}

JProjection.inheritsFrom(ControlBase);

if (typeof(loadNextScript) != 'undefined')
	loadNextScript();